/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.lookup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IWDMlaProvider;
import com.gtnewhorizons.wdmla.impl.PriorityStore;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.impl.lookup.HierarchyLookup;
import com.gtnewhorizons.wdmla.impl.lookup.IHierarchyLookup;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class WrappedHierarchyLookup<T extends IWDMlaProvider>
extends HierarchyLookup<T> {
    public final List<Pair<IHierarchyLookup<T>, Function<Accessor, @Nullable Object>>> overrides = Lists.newArrayList();
    private boolean empty = true;

    public WrappedHierarchyLookup() {
        super(Object.class);
    }

    public static <T extends IWDMlaProvider> WrappedHierarchyLookup<T> forAccessor() {
        WrappedHierarchyLookup<T> lookup = new WrappedHierarchyLookup<T>();
        lookup.overrides.add(Pair.of(new HierarchyLookup(Block.class), accessor -> {
            if (accessor instanceof BlockAccessor) {
                BlockAccessor blockAccessor = (BlockAccessor)accessor;
                return blockAccessor.getBlock();
            }
            return null;
        }));
        return lookup;
    }

    public List<T> wrappedGet(Accessor accessor) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (Pair<IHierarchyLookup<T>, Function<Accessor, Object>> override : this.overrides) {
            Object o = ((Function)override.getRight()).apply(accessor);
            if (o == null) continue;
            set.addAll(((IHierarchyLookup)override.getLeft()).get(o));
        }
        set.addAll(this.get(accessor.getTarget()));
        return (List)set.stream().sorted(Comparator.comparingInt(WDMlaCommonRegistration.instance().priorities::byValue)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    public boolean hitsAny(Accessor accessor, BiPredicate<T, Accessor> predicate) {
        for (IWDMlaProvider provider : this.wrappedGet(accessor)) {
            if (!predicate.test(provider, accessor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void register(Class<?> clazz, T provider) {
        for (Pair<IHierarchyLookup<T>, Function<Accessor, Object>> override : this.overrides) {
            if (!((IHierarchyLookup)override.getLeft()).isClassAcceptable(clazz)) continue;
            ((IHierarchyLookup)override.getLeft()).register(clazz, provider);
            this.empty = false;
            return;
        }
        super.register(clazz, provider);
        this.empty = false;
    }

    @Override
    public boolean isClassAcceptable(Class<?> clazz) {
        for (Pair<IHierarchyLookup<T>, Function<Accessor, Object>> override : this.overrides) {
            if (!((IHierarchyLookup)override.getLeft()).isClassAcceptable(clazz)) continue;
            return true;
        }
        return super.isClassAcceptable(clazz);
    }

    @Override
    public void invalidate() {
        for (Pair<IHierarchyLookup<T>, Function<Accessor, Object>> override : this.overrides) {
            ((IHierarchyLookup)override.getLeft()).invalidate();
        }
        super.invalidate();
    }

    @Override
    public void loadComplete(PriorityStore<ResourceLocation, IWDMlaProvider> priorityStore) {
        for (Pair<IHierarchyLookup<T>, Function<Accessor, Object>> override : this.overrides) {
            ((IHierarchyLookup)override.getLeft()).loadComplete(priorityStore);
        }
        super.loadComplete(priorityStore);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public Stream<Map.Entry<Class<?>, Collection<T>>> entries() {
        Stream stream = super.entries();
        for (Pair<IHierarchyLookup<T>, Function<Accessor, Object>> override : this.overrides) {
            stream = Stream.concat(stream, ((IHierarchyLookup)override.getLeft()).entries());
        }
        return stream;
    }
}

