/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

public class PriorityStore<K, V> {
    private final Object2IntMap<K> priorities = new Object2IntLinkedOpenHashMap();
    private final Function<V, K> keyGetter;
    private final ToIntFunction<V> defaultPriorityGetter;
    private ImmutableList<K> sortedList = ImmutableList.of();
    private BiFunction<PriorityStore<K, V>, Collection<K>, List<K>> sortingFunction = (store, allKeys) -> (List)allKeys.stream().sorted(Comparator.comparingInt(store::byKey)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));

    public PriorityStore(ToIntFunction<V> defaultPriorityGetter, Function<V, K> keyGetter) {
        this.defaultPriorityGetter = defaultPriorityGetter;
        this.keyGetter = keyGetter;
    }

    public void setSortingFunction(BiFunction<PriorityStore<K, V>, Collection<K>, List<K>> sortingFunction) {
        this.sortingFunction = sortingFunction;
    }

    public void put(V provider) {
        Objects.requireNonNull(provider);
        this.put(provider, this.defaultPriorityGetter.applyAsInt(provider));
    }

    public void put(V provider, int priority) {
        Objects.requireNonNull(provider);
        K uid = this.keyGetter.apply(provider);
        Objects.requireNonNull(uid);
        this.priorities.put(uid, priority);
    }

    public void putUnsafe(K key, int priority) {
        Objects.requireNonNull(key);
        this.priorities.put(key, priority);
    }

    public void sort() {
        this.sortedList = ImmutableList.copyOf((Collection)this.sortingFunction.apply(this, (Collection<K>)this.priorities.keySet()));
    }

    public int byValue(V value) {
        return this.byKey(this.keyGetter.apply(value));
    }

    public int byKey(K id) {
        return this.priorities.getInt(id);
    }

    public ImmutableList<K> getSortedList() {
        return this.sortedList;
    }
}

