/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl;

import akka.japi.Pair;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IWDMlaProvider;
import com.gtnewhorizons.wdmla.impl.WDMlaClientRegistration;
import com.gtnewhorizons.wdmla.impl.lookup.IHierarchyLookup;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;

public class ClientRegistrationSession {
    private final WDMlaClientRegistration registration;
    private boolean active;
    private final List<Pair<IComponentProvider<BlockAccessor>, Class<? extends Block>>> blockComponentProviders = Lists.newArrayList();
    private final List<Pair<IComponentProvider<EntityAccessor>, Class<? extends Entity>>> entityComponentProviders = Lists.newArrayList();

    public ClientRegistrationSession(WDMlaClientRegistration registration) {
        this.registration = registration;
    }

    private static <T extends IWDMlaProvider, C> void register(T provider, List<Pair<T, Class<? extends C>>> list, IHierarchyLookup<T> lookup, Class<? extends C> clazz) {
        Preconditions.checkArgument((boolean)lookup.isClassAcceptable(clazz), (String)"Class %s is not acceptable", (Object[])new Object[]{clazz});
        Objects.requireNonNull(provider.getUid());
        list.add(new Pair(provider, clazz));
    }

    public void registerBlockComponent(IComponentProvider<BlockAccessor> provider, Class<? extends Block> blockClass) {
        ClientRegistrationSession.register(provider, this.blockComponentProviders, this.registration.blockComponentProviders, blockClass);
    }

    public void registerEntityComponent(IComponentProvider<EntityAccessor> provider, Class<? extends Entity> entityClass) {
        ClientRegistrationSession.register(provider, this.entityComponentProviders, this.registration.entityComponentProviders, entityClass);
    }

    public void reset() {
        this.blockComponentProviders.clear();
        this.entityComponentProviders.clear();
        this.active = true;
    }

    public void end() {
        Preconditions.checkState((boolean)this.active, (Object)"Session is not active");
        this.active = false;
        this.blockComponentProviders.forEach(pair -> this.registration.registerBlockComponent((IComponentProvider)pair.first(), (Class)pair.second()));
        this.entityComponentProviders.forEach(pair -> this.registration.registerEntityComponent((IComponentProvider)pair.first(), (Class)pair.second()));
    }

    public boolean isActive() {
        return this.active;
    }
}

