/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.command;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.commands.GTNHClientCommand;
import com.gtnewhorizons.wdmla.api.provider.IWDMlaProvider;
import com.gtnewhorizons.wdmla.impl.WDMlaClientRegistration;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.impl.lookup.IHierarchyLookup;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class GenerateDumpCommand
extends GTNHClientCommand {
    public String func_71517_b() {
        return "wdmladump";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityClientPlayerMP)) {
            return;
        }
        File file = new File(Minecraft.func_71410_x().field_71412_D, "wdmla_handlers.md");
        try (FileWriter writer = new FileWriter(file);){
            writer.write(GenerateDumpCommand.generateInfoDump());
            GTNHLib.proxy.addMessageToChat((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"chat.msg.wdmla.dump.success"), file.getCanonicalPath())));
        }
        catch (IOException e) {
            WailaExceptionHandler.handleErr(e, ((Object)((Object)this)).getClass().getName(), null);
        }
    }

    public static String generateInfoDump() {
        StringBuilder builder = new StringBuilder("# Wdmla Handler Dump");
        WDMlaClientRegistration client = WDMlaClientRegistration.instance();
        WDMlaCommonRegistration common = WDMlaCommonRegistration.instance();
        builder.append("\nGenerated at ").append(ZonedDateTime.now(ZoneOffset.UTC)).append("\n");
        builder.append("\n## Block");
        GenerateDumpCommand.createSection(builder, "Component Providers", client.blockComponentProviders);
        GenerateDumpCommand.createSection(builder, "Data Providers", common.blockDataProviders);
        builder.append("\n## Entity");
        GenerateDumpCommand.createSection(builder, "Component Providers", client.entityComponentProviders);
        GenerateDumpCommand.createSection(builder, "Data Providers", common.entityDataProviders);
        builder.append("\n## Common Extension");
        GenerateDumpCommand.createSection(builder, "Item Storage", common.itemStorageProviders);
        builder.append("\n## Client Extension");
        GenerateDumpCommand.createSection(builder, "Item Storage", client.itemStorageProviders);
        builder.append("\n## Priorities");
        for (ResourceLocation resourceLocation : common.priorities.getSortedList()) {
            builder.append("\n* ").append(resourceLocation);
        }
        return builder.toString();
    }

    private static void createSection(StringBuilder builder, String subsection, Map<ResourceLocation, ? extends IWDMlaProvider> map) {
        if (map.isEmpty()) {
            return;
        }
        builder.append("\n### ").append(subsection);
        map.forEach((key, value) -> {
            builder.append("\n\n#### ").append(key);
            builder.append("\n* ").append(value.getUid()).append(", ").append(value.getClass().getName());
        });
        builder.append("\n\n");
    }

    private static void createSection(StringBuilder builder, String subsection, IHierarchyLookup<? extends IWDMlaProvider> lookup) {
        if (lookup.isEmpty()) {
            return;
        }
        builder.append("\n### ").append(subsection);
        lookup.entries().forEach(entry -> {
            builder.append("\n\n#### ").append(((Class)entry.getKey()).getName());
            ((Collection)entry.getValue()).stream().distinct().sorted(Comparator.comparingInt(WDMlaCommonRegistration.instance().priorities::byValue)).forEach($ -> builder.append("\n* ").append($.getUid()).append(", ").append(WDMlaCommonRegistration.instance().priorities.byValue((IWDMlaProvider)$)).append(", ").append($.getClass().getName()));
        });
        builder.append("\n\n");
    }
}

