/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.api.view;

import com.gtnewhorizons.wdmla.api.ui.IComponent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class FluidView {
    @Nullable
    public FluidStack overlay;
    public long current;
    public long max;
    @Nullable
    public String fluidName;
    @Nullable
    public IComponent description;
    public boolean hasScale;

    public FluidView(@Nullable FluidStack overlay) {
        this.overlay = overlay;
    }

    @Nullable
    public static FluidView readDefault(Data tank) {
        long amount;
        if (tank.capacity <= 0L) {
            return null;
        }
        FluidStack fluidObject = tank.fluid;
        FluidView fluidView = new FluidView(fluidObject);
        if (fluidObject == null) {
            amount = 0L;
            fluidView.fluidName = null;
        } else {
            amount = fluidObject.amount;
            fluidView.fluidName = fluidObject.getLocalizedName();
        }
        fluidView.current = amount;
        fluidView.max = tank.capacity;
        fluidView.hasScale = false;
        return fluidView;
    }

    public static class Data {
        public final FluidStack fluid;
        public final long capacity;

        public Data(FluidStack fluid, long capacity) {
            this.fluid = fluid;
            this.capacity = capacity;
        }

        public static NBTTagCompound encode(Data data) {
            NBTTagCompound encoded = new NBTTagCompound();
            if (data.fluid != null) {
                data.fluid.writeToNBT(encoded);
            }
            encoded.func_74772_a("capacity", data.capacity);
            return encoded;
        }

        public static Data decode(NBTTagCompound nbt) {
            return new Data(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt), nbt.func_74763_f("capacity"));
        }
    }
}

