/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.api.accessor;

import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface BlockAccessor
extends Accessor {
    public Block getBlock();

    @Nullable
    public TileEntity getTileEntity();

    public int getMetadata();

    public ItemStack getItemForm();

    @Override
    default public Class<? extends Accessor> getAccessorType() {
        return BlockAccessor.class;
    }

    @ApiStatus.NonExtendable
    public static interface Builder {
        public Builder level(World var1);

        public Builder player(EntityPlayer var1);

        public Builder serverData(NBTTagCompound var1);

        public Builder serverConnected(boolean var1);

        public Builder showDetails(boolean var1);

        public Builder hit(MovingObjectPosition var1);

        public Builder block(Block var1);

        default public Builder tileEntity(TileEntity tileEntity) {
            return this.tileEntity(() -> tileEntity);
        }

        public Builder itemForm(ItemStack var1);

        public Builder tileEntity(Supplier<TileEntity> var1);

        public Builder meta(int var1);

        public Builder requireVerification();

        public BlockAccessor build();
    }
}

