/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.api;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import java.util.function.Predicate;
import mcp.mobius.waila.Waila;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public enum Mods {
    CREATIVEBLOCKS("CreativeBlocks", null),
    GREGTECH("gregtech", version -> !Loader.isModLoaded((String)"gregapi")),
    IGUANATWEAKS("IguanaTweaksTConstruct", null),
    TCONSTUCT("TConstruct", null),
    NOTENOUGHITEMS("NotEnoughItems", version -> new DefaultArtifactVersion("2.7.29-GTNH").compareTo(version) <= 0),
    FORGEMULTIPARTS("ForgeMultipart", null);

    public final String modID;
    public final Predicate<ArtifactVersion> otherRequirement;
    private Boolean loaded;

    private Mods(String modID, Predicate<ArtifactVersion> otherRequirement) {
        this.modID = modID;
        this.otherRequirement = otherRequirement;
    }

    public boolean isLoaded() {
        if (this.loaded == null) {
            if (!Loader.isModLoaded((String)this.modID)) {
                this.loaded = false;
            } else if (this.otherRequirement != null) {
                ArtifactVersion version = ((ModContainer)Loader.instance().getIndexedModList().get(this.modID)).getProcessedVersion();
                if (this.otherRequirement.test(version)) {
                    this.loaded = true;
                } else {
                    Waila.log.info(String.format("Skipped loading %s Compatibility classes due to incompatibility. Loaded version: %s", this.modID, version.getVersionString()));
                    this.loaded = false;
                }
            } else {
                this.loaded = true;
            }
        }
        return this.loaded;
    }
}

