/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla;

import com.gtnewhorizons.wdmla.CommonProxy;
import com.gtnewhorizons.wdmla.WDMla;
import com.gtnewhorizons.wdmla.api.Mods;
import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import com.gtnewhorizons.wdmla.api.provider.IClientExtensionProvider;
import com.gtnewhorizons.wdmla.api.view.ClientViewGroup;
import com.gtnewhorizons.wdmla.api.view.ViewGroup;
import com.gtnewhorizons.wdmla.command.GenerateDumpCommand;
import com.gtnewhorizons.wdmla.command.PrintUnsupportedTEsCommand;
import com.gtnewhorizons.wdmla.config.WDMlaConfig;
import com.gtnewhorizons.wdmla.overlay.WDMlaTickHandler;
import com.gtnewhorizons.wdmla.plugin.harvestability.proxy.ProxyGregTech;
import com.gtnewhorizons.wdmla.plugin.harvestability.proxy.ProxyIguanaTweaks;
import com.gtnewhorizons.wdmla.plugin.harvestability.proxy.ProxyTinkersConstruct;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.command.ICommand;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.Nullable;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        File wdmlaConfigFolder = new File(event.getModConfigurationDirectory().getPath(), "WDMla");
        File wdmlaConfig = new File(wdmlaConfigFolder, "plugins_autogen.cfg");
        new WDMlaConfig(wdmlaConfig);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        WDMlaTickHandler tickHandler = new WDMlaTickHandler();
        FMLCommonHandler.instance().bus().register((Object)tickHandler);
        MinecraftForge.EVENT_BUS.register((Object)tickHandler);
        FMLCommonHandler.instance().bus().register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new GenerateDumpCommand());
        if (WDMla.isDevEnv()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new PrintUnsupportedTEsCommand());
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        if (Mods.TCONSTUCT.isLoaded()) {
            ProxyTinkersConstruct.init();
        }
        if (Mods.IGUANATWEAKS.isLoaded()) {
            ProxyIguanaTweaks.init();
        }
        if (Mods.GREGTECH.isLoaded()) {
            ProxyGregTech.init();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("wdmla")) {
            WDMlaConfig.instance().save();
            WDMlaConfig.instance().reloadConfig();
            ClientProxy.loadComplete();
            ConfigHandler.instance().reloadDefaultConfig();
        }
    }

    @Nullable
    public static <IN, OUT> List<ClientViewGroup<OUT>> mapToClientGroups(Accessor accessor, ResourceLocation key, Function<NBTTagCompound, Map.Entry<ResourceLocation, List<ViewGroup<IN>>>> decoder, Function<ResourceLocation, IClientExtensionProvider<IN, OUT>> mapper) {
        NBTBase tagBase = accessor.getServerData().func_74781_a(key.toString());
        if (!(tagBase instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound tag = (NBTTagCompound)tagBase;
        Map.Entry<ResourceLocation, List<ViewGroup<IN>>> entry = decoder.apply(tag);
        if (entry == null) {
            return null;
        }
        IClientExtensionProvider<IN, OUT> provider = mapper.apply(entry.getKey());
        if (provider == null) {
            return null;
        }
        try {
            return provider.getClientGroups(accessor, entry.getValue());
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, provider.getClass().getName(), null);
            return null;
        }
    }
}

