/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.factory.TileTank;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;

public class BlockTank
extends BlockBuildCraft {
    private static final boolean DEBUG_MODE = false;
    private IIcon textureStackedSide;

    public BlockTank() {
        super(Material.field_151592_s);
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        this.func_149711_c(0.5f);
        this.func_149647_a(BCCreativeTab.get("main"));
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            tank.onBlockBreak();
        }
        TileEntity tileAbove = world.func_147438_o(x, y + 1, z);
        TileEntity tileBelow = world.func_147438_o(x, y - 1, z);
        super.func_149749_a(world, x, y, z, block, par6);
        if (tileAbove instanceof TileTank) {
            ((TileTank)tileAbove).updateComparators();
        }
        if (tileBelow instanceof TileTank) {
            ((TileTank)tileBelow).updateComparators();
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileTank();
    }

    @Override
    public IIcon getIconAbsolute(IBlockAccess iblockaccess, int i, int j, int k, int side, int metadata) {
        if (side >= 2 && iblockaccess.func_147439_a(i, j - 1, k) instanceof BlockTank) {
            return this.textureStackedSide;
        }
        return super.getIconAbsolute(side, metadata);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        FluidStack containerFluid;
        if (super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack held = player.field_71071_by.func_70448_g();
        if (held == null) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileTank)) {
            return false;
        }
        TileTank clicked = (TileTank)te;
        boolean creative = player.field_71075_bZ.field_75098_d;
        if (FluidContainerRegistry.isContainer((ItemStack)held)) {
            ItemStack preview;
            FluidStack willContain;
            FluidStack fromItem = FluidContainerRegistry.getFluidForFilledItem((ItemStack)held);
            if (fromItem != null) {
                int moved = clicked.fill(ForgeDirection.UNKNOWN, fromItem, true);
                if (moved > 0 && !BuildCraftCore.debugWorldgen && !creative) {
                    ItemStack emptied = FluidContainerRegistry.drainFluidContainer((ItemStack)held);
                    if (held.field_77994_a > 1) {
                        BlockTank.addOrDrop(player, emptied);
                        --held.field_77994_a;
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, emptied);
                    }
                }
                BlockTank.syncPlayerAndTanks(world, x, y, z, player, clicked);
                return true;
            }
            FluidStack available = clicked.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
            if (available != null && (willContain = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(preview = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)held)))) != null) {
                if (!BuildCraftCore.debugWorldgen && !creative) {
                    if (held.field_77994_a > 1) {
                        if (!player.field_71071_by.func_70441_a(preview)) {
                            return false;
                        }
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvUtils.consumeItem(held));
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, preview);
                    }
                }
                clicked.drain(ForgeDirection.UNKNOWN, willContain.amount, true);
                BlockTank.syncPlayerAndTanks(world, x, y, z, player, clicked);
                return true;
            }
            return false;
        }
        if (!(held.func_77973_b() instanceof IFluidContainerItem)) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        IFluidContainerItem fluidContainer = (IFluidContainerItem)held.func_77973_b();
        boolean sneaking = player.func_70093_af();
        ItemStack work = held.func_77946_l();
        work.field_77994_a = 1;
        TileTank bottom = clicked.getBottomTank();
        if (bottom == null) {
            return true;
        }
        int moved = 0;
        if (!sneaking && (containerFluid = fluidContainer.getFluid(work)) != null && containerFluid.amount > 0 && (moved = bottom.fill(ForgeDirection.UNKNOWN, containerFluid, true)) > 0 && !creative) {
            fluidContainer.drain(work, moved, true);
        }
        if (sneaking) {
            FluidStack drained;
            int accept;
            FluidStack target;
            FluidStack inCell = fluidContainer.getFluid(work);
            FluidStack stackFluid = bottom.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
            FluidStack fluidStack = target = inCell != null && inCell.amount > 0 ? inCell : stackFluid;
            if (target != null && target.getFluid() != null && (accept = fluidContainer.fill(work, new FluidStack(target.getFluid(), fluidContainer.getCapacity(work)), false)) > 0 && (drained = bottom.drain(ForgeDirection.UNKNOWN, new FluidStack(target.getFluid(), accept), true)) != null && drained.amount > 0) {
                moved = creative ? drained.amount : fluidContainer.fill(work, drained, true);
            }
        }
        if (moved > 0) {
            if (creative) {
                BlockTank.syncPlayerAndTanks(world, x, y, z, player, clicked, bottom);
                return true;
            }
            if (held.field_77994_a > 1) {
                --held.field_77994_a;
                BlockTank.addOrDrop(player, work);
            } else {
                int slot = player.field_71071_by.field_70461_c;
                player.field_71071_by.func_70299_a(slot, work);
            }
            BlockTank.syncPlayerAndTanks(world, x, y, z, player, clicked, bottom);
        }
        return true;
    }

    private static void addOrDrop(EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    private static void syncPlayerAndTanks(World world, int x, int y, int z, EntityPlayer player, TileTank ... tanks) {
        player.field_71071_by.func_70296_d();
        if (player.field_71070_bA != null) {
            player.field_71070_bA.func_75142_b();
        }
        if (player.field_71069_bz != null) {
            player.field_71069_bz.func_75142_b();
        }
        for (TileTank tt : tanks) {
            if (tt == null) continue;
            tt.func_70296_d();
            world.func_147471_g(tt.field_145851_c, tt.field_145848_d, tt.field_145849_e);
        }
        world.func_147471_g(x, y, z);
    }

    private static void debugTankStack(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te;
        if (world.field_72995_K) {
            return;
        }
        TileTank clicked = (TileTank)world.func_147438_o(x, y, z);
        TileTank bottom = clicked.getBottomTank();
        if (bottom == null) {
            return;
        }
        int totalAmt = 0;
        int totalCap = 0;
        int tanks = 0;
        String fluidName = "empty";
        int yy = bottom.field_145848_d;
        while ((te = world.func_147438_o(x, yy, z)) instanceof TileTank) {
            TileTank t = (TileTank)te;
            FluidTankInfo info = t.getTankInfo(ForgeDirection.UNKNOWN)[0];
            if (info.fluid != null && info.fluid.amount > 0) {
                fluidName = info.fluid.getLocalizedName();
                totalAmt += info.fluid.amount;
            }
            totalCap += info.capacity;
            ++tanks;
            ++yy;
        }
        player.func_146105_b((IChatComponent)new ChatComponentText("BC Tank stack: " + tanks + " tanks | Fluid: " + fluidName + " | Total: " + totalAmt + " / " + totalCap + " mB"));
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        if (side <= 1) {
            return !(world.func_147439_a(x, y, z) instanceof BlockTank);
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        super.func_149651_a(par1IconRegister);
        this.textureStackedSide = par1IconRegister.func_94245_a("buildcraftfactory:tankBlock/side_stacked");
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            return tank.getFluidLightLevel();
        }
        return super.getLightValue(world, x, y, z);
    }

    @Override
    public boolean func_149740_M() {
        return true;
    }

    @Override
    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            return tank.getComparatorInputOverride();
        }
        return 0;
    }
}

