/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.Vertex5;
import cofh.repack.codechicken.lib.vec.Matrix4;
import cofh.repack.codechicken.lib.vec.Quat;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Scale;
import cofh.repack.codechicken.lib.vec.Vector3;

public class CCModelLibrary {
    public static CCModel icosahedron4;
    public static CCModel icosahedron7;
    private static int i;

    private static void generateIcosahedron() {
        Vector3[] vector3Array = new Vector3[]{new Vector3(-1.0, 1.618033988749894, 0.0), new Vector3(1.0, 1.618033988749894, 0.0), new Vector3(1.0, -1.618033988749894, 0.0), new Vector3(-1.0, -1.618033988749894, 0.0), new Vector3(0.0, -1.0, 1.618033988749894), new Vector3(0.0, 1.0, 1.618033988749894), new Vector3(0.0, 1.0, -1.618033988749894), new Vector3(0.0, -1.0, -1.618033988749894), new Vector3(1.618033988749894, 0.0, -1.0), new Vector3(1.618033988749894, 0.0, 1.0), new Vector3(-1.618033988749894, 0.0, 1.0), new Vector3(-1.618033988749894, 0.0, -1.0)};
        Quat quat = Quat.aroundAxis(0.0, 0.0, 1.0, Math.atan(0.6180339887498951));
        for (Vector3 vector3 : vector3Array) {
            quat.rotate(vector3);
        }
        icosahedron4 = CCModel.newModel(4, 60);
        icosahedron7 = CCModel.newModel(7, 80);
        i = 0;
        CCModelLibrary.addIcosahedronTriangle(vector3Array[1], 0.5, 0.0, vector3Array[0], 0.0, 0.25, vector3Array[5], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[1], 0.5, 0.0, vector3Array[5], 0.0, 0.25, vector3Array[9], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[1], 0.5, 0.0, vector3Array[9], 0.0, 0.25, vector3Array[8], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[1], 0.5, 0.0, vector3Array[8], 0.0, 0.25, vector3Array[6], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[1], 0.5, 0.0, vector3Array[6], 0.0, 0.25, vector3Array[0], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[0], 0.5, 0.25, vector3Array[11], 0.0, 0.75, vector3Array[10], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[5], 0.5, 0.25, vector3Array[10], 0.0, 0.75, vector3Array[4], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[9], 0.5, 0.25, vector3Array[4], 0.0, 0.75, vector3Array[2], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[8], 0.5, 0.25, vector3Array[2], 0.0, 0.75, vector3Array[7], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[6], 0.5, 0.25, vector3Array[7], 0.0, 0.75, vector3Array[11], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[2], 0.5, 0.75, vector3Array[8], 0.0, 0.25, vector3Array[9], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[7], 0.5, 0.75, vector3Array[6], 0.0, 0.25, vector3Array[8], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[11], 0.5, 0.75, vector3Array[0], 0.0, 0.25, vector3Array[6], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[10], 0.5, 0.75, vector3Array[5], 0.0, 0.25, vector3Array[0], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[4], 0.5, 0.75, vector3Array[9], 0.0, 0.25, vector3Array[5], 1.0, 0.25);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[3], 0.5, 1.0, vector3Array[2], 0.0, 0.75, vector3Array[4], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[3], 0.5, 1.0, vector3Array[7], 0.0, 0.75, vector3Array[2], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[3], 0.5, 1.0, vector3Array[11], 0.0, 0.75, vector3Array[7], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[3], 0.5, 1.0, vector3Array[10], 0.0, 0.75, vector3Array[11], 1.0, 0.75);
        CCModelLibrary.addIcosahedronTriangle(vector3Array[3], 0.5, 1.0, vector3Array[4], 0.0, 0.75, vector3Array[10], 1.0, 0.75);
        icosahedron4.computeNormals().smoothNormals();
        icosahedron7.computeNormals().smoothNormals();
    }

    private static void addIcosahedronTriangle(Vector3 vector3, double d, double d2, Vector3 vector32, double d3, double d4, Vector3 vector33, double d5, double d6) {
        Vertex5 vertex5 = new Vertex5(vector3, d, d2);
        CCModelLibrary.icosahedron7.verts[CCModelLibrary.i * 4] = vertex5;
        CCModelLibrary.icosahedron4.verts[CCModelLibrary.i * 3] = vertex5;
        Vertex5 vertex52 = new Vertex5(vector32, d3, d4);
        CCModelLibrary.icosahedron7.verts[CCModelLibrary.i * 4 + 1] = vertex52;
        CCModelLibrary.icosahedron4.verts[CCModelLibrary.i * 3 + 1] = vertex52;
        Vertex5 vertex53 = new Vertex5(vector33, d5, d6);
        CCModelLibrary.icosahedron7.verts[CCModelLibrary.i * 4 + 3] = vertex53;
        CCModelLibrary.icosahedron7.verts[CCModelLibrary.i * 4 + 2] = vertex53;
        CCModelLibrary.icosahedron4.verts[CCModelLibrary.i * 3 + 2] = vertex53;
        ++i;
    }

    public static Matrix4 getRenderMatrix(Vector3 vector3, Rotation rotation, double d) {
        return new Matrix4().translate(vector3).apply(new Scale(d)).apply(rotation);
    }

    static {
        CCModelLibrary.generateIcosahedron();
    }
}

