/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityHelper {
    private EntityHelper() {
    }

    public static int getEntityFacingCardinal(EntityLivingBase entityLivingBase) {
        int n = MathHelper.floor((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
        }
        return 4;
    }

    public static ForgeDirection getEntityFacingForgeDirection(EntityLivingBase entityLivingBase) {
        return ForgeDirection.VALID_DIRECTIONS[EntityHelper.getEntityFacingCardinal(entityLivingBase)];
    }

    public static void transferEntityToDimension(Entity entity, int n, ServerConfigurationManager serverConfigurationManager) {
        if (entity instanceof EntityPlayerMP) {
            EntityHelper.transferPlayerToDimension((EntityPlayerMP)entity, n, serverConfigurationManager);
            return;
        }
        WorldServer worldServer = serverConfigurationManager.func_72365_p().func_71218_a(entity.field_71093_bK);
        entity.field_71093_bK = n;
        WorldServer worldServer2 = serverConfigurationManager.func_72365_p().func_71218_a(entity.field_71093_bK);
        worldServer.func_72973_f(entity);
        if (entity.field_70153_n != null) {
            entity.field_70153_n.func_70078_a(null);
        }
        if (entity.field_70154_o != null) {
            entity.func_70078_a(null);
        }
        entity.field_70128_L = false;
        EntityHelper.transferEntityToWorld(entity, worldServer, worldServer2);
    }

    public static void transferEntityToWorld(Entity entity, WorldServer worldServer, WorldServer worldServer2) {
        WorldProvider worldProvider = worldServer.field_73011_w;
        WorldProvider worldProvider2 = worldServer2.field_73011_w;
        double d = worldProvider.getMovementFactor() / worldProvider2.getMovementFactor();
        double d2 = entity.field_70165_t * d;
        double d3 = entity.field_70161_v * d;
        worldServer.field_72984_F.func_76320_a("placing");
        d2 = net.minecraft.util.MathHelper.func_151237_a((double)d2, (double)-2.9999872E7, (double)2.9999872E7);
        d3 = net.minecraft.util.MathHelper.func_151237_a((double)d3, (double)-2.9999872E7, (double)2.9999872E7);
        if (entity.func_70089_S()) {
            entity.func_70012_b(d2, entity.field_70163_u, d3, entity.field_70177_z, entity.field_70125_A);
            entity.field_98038_p = true;
            worldServer2.func_72838_d(entity);
            entity.field_98038_p = false;
            worldServer2.func_72866_a(entity, false);
        }
        worldServer.field_72984_F.func_76319_b();
        entity.func_70029_a((World)worldServer2);
    }

    public static void transferPlayerToDimension(EntityPlayerMP entityPlayerMP, int n, ServerConfigurationManager serverConfigurationManager) {
        int n2 = entityPlayerMP.field_71093_bK;
        WorldServer worldServer = serverConfigurationManager.func_72365_p().func_71218_a(entityPlayerMP.field_71093_bK);
        entityPlayerMP.field_71093_bK = n;
        WorldServer worldServer2 = serverConfigurationManager.func_72365_p().func_71218_a(entityPlayerMP.field_71093_bK);
        entityPlayerMP.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(entityPlayerMP.field_71093_bK, entityPlayerMP.field_70170_p.field_73013_u, entityPlayerMP.field_70170_p.func_72912_H().func_76067_t(), entityPlayerMP.field_71134_c.func_73081_b()));
        worldServer.func_72973_f((Entity)entityPlayerMP);
        if (entityPlayerMP.field_70153_n != null) {
            entityPlayerMP.field_70153_n.func_70078_a(null);
        }
        if (entityPlayerMP.field_70154_o != null) {
            entityPlayerMP.func_70078_a(null);
        }
        entityPlayerMP.field_70128_L = false;
        EntityHelper.transferEntityToWorld((Entity)entityPlayerMP, worldServer, worldServer2);
        serverConfigurationManager.func_72375_a(entityPlayerMP, worldServer);
        entityPlayerMP.field_71135_a.func_147364_a(entityPlayerMP.field_70165_t, entityPlayerMP.field_70163_u, entityPlayerMP.field_70161_v, entityPlayerMP.field_70177_z, entityPlayerMP.field_70125_A);
        entityPlayerMP.field_71134_c.func_73080_a(worldServer2);
        serverConfigurationManager.func_72354_b(entityPlayerMP, worldServer2);
        serverConfigurationManager.func_72385_f(entityPlayerMP);
        for (PotionEffect potionEffect : entityPlayerMP.func_70651_bq()) {
            entityPlayerMP.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(entityPlayerMP.func_145782_y(), potionEffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)entityPlayerMP, n2, n);
    }

    public static void transferEntityToDimension(Entity entity, double d, double d2, double d3, int n, ServerConfigurationManager serverConfigurationManager) {
        if (entity instanceof EntityPlayerMP) {
            EntityHelper.transferPlayerToDimension((EntityPlayerMP)entity, d, d2, d3, n, serverConfigurationManager);
            return;
        }
        if (entity.field_70153_n != null) {
            entity.field_70153_n.func_70078_a(null);
        }
        if (entity.field_70154_o != null) {
            entity.func_70078_a(null);
        }
        WorldServer worldServer = serverConfigurationManager.func_72365_p().func_71218_a(entity.field_71093_bK);
        entity.field_71093_bK = n;
        WorldServer worldServer2 = serverConfigurationManager.func_72365_p().func_71218_a(entity.field_71093_bK);
        worldServer.func_72973_f(entity);
        entity.field_70128_L = false;
        EntityHelper.transferEntityToWorld(entity, d, d2, d3, worldServer, worldServer2);
    }

    public static void transferEntityToWorld(Entity entity, double d, double d2, double d3, WorldServer worldServer, WorldServer worldServer2) {
        worldServer.field_72984_F.func_76320_a("placing");
        d = net.minecraft.util.MathHelper.func_151237_a((double)d, (double)-2.9999872E7, (double)2.9999872E7);
        d3 = net.minecraft.util.MathHelper.func_151237_a((double)d3, (double)-2.9999872E7, (double)2.9999872E7);
        if (entity.func_70089_S()) {
            entity.func_70012_b(d, d2, d3, entity.field_70177_z, entity.field_70125_A);
            entity.field_98038_p = true;
            worldServer2.func_72838_d(entity);
            entity.field_98038_p = false;
            worldServer2.func_72866_a(entity, false);
        }
        worldServer.field_72984_F.func_76319_b();
        entity.func_70029_a((World)worldServer2);
    }

    public static void transferPlayerToDimension(EntityPlayerMP entityPlayerMP, double d, double d2, double d3, int n, ServerConfigurationManager serverConfigurationManager) {
        int n2 = entityPlayerMP.field_71093_bK;
        WorldServer worldServer = serverConfigurationManager.func_72365_p().func_71218_a(entityPlayerMP.field_71093_bK);
        entityPlayerMP.field_71093_bK = n;
        WorldServer worldServer2 = serverConfigurationManager.func_72365_p().func_71218_a(entityPlayerMP.field_71093_bK);
        entityPlayerMP.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(entityPlayerMP.field_71093_bK, entityPlayerMP.field_70170_p.field_73013_u, entityPlayerMP.field_70170_p.func_72912_H().func_76067_t(), entityPlayerMP.field_71134_c.func_73081_b()));
        worldServer.func_72973_f((Entity)entityPlayerMP);
        if (entityPlayerMP.field_70153_n != null) {
            entityPlayerMP.field_70153_n.func_70078_a(null);
        }
        if (entityPlayerMP.field_70154_o != null) {
            entityPlayerMP.func_70078_a(null);
        }
        entityPlayerMP.field_70128_L = false;
        EntityHelper.transferEntityToWorld((Entity)entityPlayerMP, d, d2, d3, worldServer, worldServer2);
        serverConfigurationManager.func_72375_a(entityPlayerMP, worldServer);
        entityPlayerMP.field_71135_a.func_147364_a(d, d2, d3, entityPlayerMP.field_70177_z, entityPlayerMP.field_70125_A);
        entityPlayerMP.field_71134_c.func_73080_a(worldServer2);
        serverConfigurationManager.func_72354_b(entityPlayerMP, worldServer2);
        serverConfigurationManager.func_72385_f(entityPlayerMP);
        for (PotionEffect potionEffect : entityPlayerMP.func_70651_bq()) {
            entityPlayerMP.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(entityPlayerMP.func_145782_y(), potionEffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)entityPlayerMP, n2, n);
    }
}

