/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.feature;

import cofh.core.world.FeatureParser;
import cofh.core.world.feature.UniformParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.feature.FeatureBase;
import cofh.lib.world.feature.FeatureGenUnderfluid;
import com.google.gson.JsonObject;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Logger;

public class UnderfluidParser
extends UniformParser {
    private boolean isUnderwater;

    public UnderfluidParser(boolean bl) {
        this.isUnderwater = bl;
    }

    @Override
    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.field_150346_d, -1), new WeightedRandomBlock((Block)Blocks.field_150349_c, -1));
    }

    @Override
    protected FeatureBase getFeature(String string, JsonObject jsonObject, WorldGenerator worldGenerator, List<WeightedRandomBlock> list, int n, FeatureBase.GenRestriction genRestriction, boolean bl, FeatureBase.GenRestriction genRestriction2, Logger logger) {
        boolean bl2 = true;
        int[] nArray = null;
        if (jsonObject.has("genFluid")) {
            ArrayList<DungeonHooks.DungeonMob> arrayList = new ArrayList<DungeonHooks.DungeonMob>();
            if (FeatureParser.parseWeightedStringList(jsonObject.get("genFluid"), arrayList)) {
                bl2 = false;
                TIntHashSet tIntHashSet = new TIntHashSet();
                for (DungeonHooks.DungeonMob dungeonMob : arrayList) {
                    Fluid fluid = FluidRegistry.getFluid((String)dungeonMob.type);
                    if (fluid == null) continue;
                    tIntHashSet.add(fluid.getID());
                }
                nArray = tIntHashSet.toArray();
            }
        }
        if (bl2) {
            return new FeatureGenUnderfluid(string, worldGenerator, list, n, genRestriction, bl, genRestriction2);
        }
        return new FeatureGenUnderfluid(string, worldGenerator, list, nArray, n, genRestriction, bl, genRestriction2);
    }

    @Override
    protected String getDefaultTemplate() {
        return this.isUnderwater ? "plate" : super.getDefaultTemplate();
    }
}

